/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GENERIC_INTERFACE_HEADER_INCLUDED__
#define __GENERIC_INTERFACE_HEADER_INCLUDED__

#include "windows.h"

#ifdef _WIN32
#include <tchar.h>
#else
#define TCHAR char
#endif

#define MAX_NAME 100

#define ARNOLD_STATUS_ROM_OK 1
#define SETTINGS_READ_MODE 2
#define SETTINGS_WRITE_MODE 3

#include "../../cpc/cpcglob.h"
#include "../../cpc/multface.h"

void GenericInterface_Initialise(void);

void SetString(TCHAR **, const TCHAR *);

extern TCHAR DiskImagePath[MAX_PATH];						/* path for opening disk images */
extern TCHAR CartridgePath[MAX_PATH];						/* path for opening cartridges */
extern TCHAR SnapshotPath[MAX_PATH];						/* path for opening snapshots */
extern TCHAR RomPath[MAX_PATH];								/* path for opening roms */
extern TCHAR ScreenSnapshotPath[MAX_PATH];					/* path for writing screen snapshots */
extern TCHAR WavOutputPath[MAX_PATH];						/* path for writing wav recording of sound */
extern TCHAR AYOutputPath[MAX_PATH];						/* path for writing recording of ay */
extern TCHAR TapePath[MAX_PATH];							/* path for opening tapes */

extern TCHAR LastOpenedRom[MAX_PATH];						/* filename of last opened rom */
extern TCHAR RomFilenames[17][MAX_PATH];					/* filenames of opened roms */
extern TCHAR CartridgeFilename[MAX_PATH];					/* filename of last opened cartridge */
extern TCHAR SnapshotFilename[MAX_PATH];					/* filename of last opened/saved snapshot */
extern TCHAR WavOutputFilename[MAX_PATH];					/* filename of last wav recording */
extern TCHAR AYOutputFilename[MAX_PATH];					/* filename of last AY recording */
extern TCHAR CheatFilename[MAX_PATH];						/* filename of cheat database */
extern TCHAR DriveFilenames[2][MAX_PATH];					/* filename of last disk image opened for drive A */
extern TCHAR DriveAFilename[MAX_PATH];						/* filename of last disk image opened for drive A */
extern TCHAR DriveBFilename[MAX_PATH];						/* filename of last disk image opened for drive B */
extern TCHAR TapeFilename[MAX_PATH];						/* filename of last tape opened */
extern TCHAR Multiface_CPC_ROM_Filename[MAX_PATH];			/* filename of CPC version of multiface rom */
extern TCHAR Multiface_CPCPLUS_ROM_Filename[MAX_PATH];		/* filename of CPC+ version of multiface rom */

extern int BasicCPCtype;
extern int BasicCRTCtype;
extern CPC_MONITOR_TYPE_ID BasicMonitortype;

extern int CPCType;
extern BOOL fShowQuit;
extern BOOL fShowReset;
extern int accuracyLevel;
extern BOOL Host_LockSpeed;
extern BOOL SpeedDrive;
extern BOOL Slowdown;
extern short BoostZ80;

/* insert a snapshot */
BOOL	GenericInterface_LoadSnapshot(const TCHAR *FilenameBuffer);
/* insert a tape-image or sample file */
BOOL	GenericInterface_InsertTape(TCHAR *FilenameBuffer);
/* insert a cartridge */
BOOL	GenericInterface_InsertCartridge(const TCHAR *FilenameBuffer);

/* restore settings */
void GenericInterface_RestoreSettings(void);
/* store settings */
void GenericInterface_StoreSettings(void);

BOOL GenericInterface_SaveScreenSnapshot(const TCHAR *FilenameBuffer,BOOL b);
BOOL GenericInterface_LoadRom(int RomIndex, const TCHAR *FilenameBuffer);
BOOL GenericInterface_SnapshotSave(const TCHAR *FilenameBuffer);


//int Multiface_LoadRomFromFile(const MULTIFACE_ROM_TYPE RomType, const TCHAR *pFilename);

BOOL TapeImage_InsertFromFile(const TCHAR *Filename);

//option dialog
void Options_PropertySheet(HWND hwndParent);

//**************************************************************
//recent file
#define MAX_RECENT_ITEMS	8
#define RECENT_ITEMS_FIRST_MENU_POS 7
#define RECENT_LIST_FILES 0

typedef struct
{
	char sFilename[MAX_PATH];				/* the fully qualified path and filename */
	char sDisplayName[MAX_PATH];			/* the name displayed in the recent menu */
} RECENT_FILE_ITEM;

typedef struct
{
	int					nItems;		/* number of items defined */
	RECENT_FILE_ITEM	Items[MAX_RECENT_ITEMS + 1];	 /* the items */
} RECENT_ITEMS;

void RecentFiles_Init(void);
void RecentFiles_Free(int nIndex);
int RecentFiles_Find(LPCTSTR sFilename);
void RecentFiles_Remove(LPCTSTR sFilename);
void RecentFiles_Add(LPCTSTR sFilename);
HMENU RecentFiles_GetFileMenu(HWND hwnd);
void RecentFiles_EnableMenu(HWND hwnd, BOOL fEnable);
HMENU RecentFiles_GetMenu(HWND hwnd);
void RecentFiles_RefreshMenu(HWND hwnd);
void RecentFiles_AddAndRefresh(HWND hwnd,LPCTSTR sFilename, int nRecentListID);
void RecentFiles_Restore(LPCTSTR sPrefix);
void RecentFiles_Store(int nRecentListID, LPCTSTR sPrefix);
BOOL RecentItems_Handle(WORD wID);

//extern RECENT_ITEMS RecentFiles;

#endif

